const express = require("express");
const router = express.Router();
const instructorController = require("../controllers/instructorController");
const authController = require("../controllers/authController");
const checkApiKey = require("../utils/checkApiKey");
const {
  uploadStaffPhoto,
} = require("../storage/middlewareStorage/uploadStaffMedia"); // Reuse staff upload

// --- Public Routes (Read-Only) ---
router.route("/").get(checkApiKey, instructorController.getAllInstructors);

router.route("/:id").get(checkApiKey, instructorController.getInstructor);

// --- Protected Routes (Admin Only) ---
router.use(authController.protect);
router.use(authController.restrictTo("admin", "super-admin"));

router.route("/").post(uploadStaffPhoto, instructorController.createInstructor); // ✅ Uses correct create method

router
  .route("/:id")
  .patch(uploadStaffPhoto, instructorController.updateInstructor)
  .delete(instructorController.deleteInstructor);

module.exports = router;
